/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.registry;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blockentities.BaseBarrelBlockEntity;
import org.betterx.bclib.blockentities.BaseChestBlockEntity;
import org.betterx.bclib.blockentities.BaseFurnaceBlockEntity;
import org.betterx.bclib.blockentities.DynamicBlockEntityType;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.blocks.signs.BaseSignBlock;
import org.betterx.bclib.furniture.entity.EntityChair;

public class BaseBlockEntities {
    public static final DynamicBlockEntityType<BaseChestBlockEntity> CHEST = BaseBlockEntities.registerBlockEntityType(BCLib.makeID("chest"), BaseChestBlockEntity::new);
    public static final DynamicBlockEntityType<BaseBarrelBlockEntity> BARREL = BaseBlockEntities.registerBlockEntityType(BCLib.makeID("barrel"), BaseBarrelBlockEntity::new);
    public static final DynamicBlockEntityType<BaseFurnaceBlockEntity> FURNACE = BaseBlockEntities.registerBlockEntityType(BCLib.makeID("furnace"), BaseFurnaceBlockEntity::new);
    public static final EntityType<EntityChair> CHAIR = BaseBlockEntities.registerEntity(BCLib.makeID("chair"), FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, EntityChair::new).dimensions(EntityDimensions.m_20398_((float)0.5f, (float)0.8f)).fireImmune().disableSummon().build());

    public static <T extends Entity> EntityType<T> registerEntity(ResourceLocation id, EntityType<T> entity) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)id, entity);
        return entity;
    }

    public static <T extends BlockEntity> DynamicBlockEntityType<T> registerBlockEntityType(ResourceLocation typeId, DynamicBlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        return (DynamicBlockEntityType)((Object)Registry.m_122965_((Registry)BuiltInRegistries.f_257049_, (ResourceLocation)typeId, new DynamicBlockEntityType<T>(supplier)));
    }

    public static void register() {
    }

    public static Block[] getChests() {
        return (Block[])BuiltInRegistries.f_256975_.m_123024_().filter(block -> block instanceof BaseChestBlock).toArray(Block[]::new);
    }

    public static Block[] getBarrels() {
        return (Block[])BuiltInRegistries.f_256975_.m_123024_().filter(block -> block instanceof BaseBarrelBlock).toArray(Block[]::new);
    }

    public static Block[] getSigns() {
        return (Block[])BuiltInRegistries.f_256975_.m_123024_().filter(block -> block instanceof BaseSignBlock).toArray(Block[]::new);
    }

    public static Block[] getFurnaces() {
        return (Block[])BuiltInRegistries.f_256975_.m_123024_().filter(block -> block instanceof BaseFurnaceBlock).toArray(Block[]::new);
    }
}

